# Troubleshooting - Frontend

## Erro: "Failed to fetch"

**Causa**: CORS ou API não acessível.

**Solução**:
1. Verificar `CORS` no backend
2. Verificar URL da API em `config/api.ts`
3. Verificar se backend está rodando

## Erro: Dados não atualizam

**Causa**: Cache ou watchers não disparando.

**Solução**:
1. Verificar se `filterTrigger` está incrementando
2. Limpar `localStorage`
3. Verificar se composable está sendo chamado

## Erro: TypeScript errors

**Causa**: Tipos incorretos ou ausentes.

**Solução**:
1. Verificar definições em `types/`
2. Adicionar tipos faltantes
3. Usar `as` apenas quando necessário

## Erro: Build falha

**Causa**: Dependências ou configuração incorreta.

**Solução**:
1. Deletar `node_modules` e `package-lock.json`
2. Executar `npm install`
3. Verificar versão do Node.js (20.19.0+ ou 22.12.0+)

## Performance: Chamadas lentas com XAMPP

**Causa**: O XAMPP (Apache) não é otimizado para servir aplicações SPA modernas e pode causar lentidão significativa nas requisições.

**Sintomas**:
- Requisições API demoram muito para responder
- Interface fica lenta ou "travando"
- Timeouts frequentes
- Alto uso de CPU/memória do Apache

**Solução Recomendada**:
1. **Para desenvolvimento**: Use o servidor de desenvolvimento do Vite:
   ```bash
   cd frontend
   npm run dev
   ```
   - Mais rápido e otimizado
   - Hot reload automático
   - Melhor para desenvolvimento

2. **Para produção local**: Use um servidor web otimizado:
   - **Nginx** (recomendado): Melhor performance para servir arquivos estáticos
   - **Servidor Node.js simples**: `npx serve -s dist`
   - **Servidor Python**: `python -m http.server 8000`

3. **Evite usar XAMPP** para:
   - Desenvolvimento ativo
   - Testes de performance
   - Ambientes que exigem baixa latência

**Nota**: O XAMPP é útil apenas para testes rápidos ou quando não há alternativa. Para melhor experiência, prefira o servidor de desenvolvimento do Vite ou um servidor web otimizado.

---

**Voltar**: [Troubleshooting Backend](./01-backend.md)
