# Troubleshooting - Backend

## Erro: "API Key inválida"

**Causa**: API Key não configurada ou incorreta.

**Solução**:
1. Verificar variável de ambiente `API_KEY`
2. Verificar se header `X-API-Key` está sendo enviado
3. Comparar chaves (case-sensitive)

## Erro: "Rate limit excedido"

**Causa**: Muitas requisições em pouco tempo.

**Solução**:
1. Verificar configuração em `RateLimitSubscriber`
2. Aguardar janela de tempo
3. Implementar cache no frontend

## Erro: Query lenta

**Causa**: Falta de índices ou query mal otimizada.

**Solução**:
1. Analisar query com `EXPLAIN`
2. Adicionar índices necessários
3. Otimizar JOINs e subqueries

## Erro: "Class not found"

**Causa**: Autoload não atualizado.

**Solução**:
```bash
composer dump-autoload
```

## Erro: Cache não limpa

**Causa**: Cache do Symfony não foi limpo.

**Solução**:
```bash
php bin/console cache:clear
```

## Performance: Lentidão geral

**Causa**: Vários fatores podem causar lentidão, incluindo uso do XAMPP.

**Soluções**:
1. **Evite usar XAMPP para backend**: O Apache do XAMPP não é otimizado para aplicações Symfony modernas
   - Use o servidor PHP embutido: `php -S localhost:8081 -t public`
   - Ou configure um servidor web otimizado (Nginx + PHP-FPM)

2. **Otimize queries do banco**:
   - Verifique índices faltantes
   - Use `EXPLAIN` para analisar queries lentas
   - Considere cache de queries frequentes

3. **Configure OPcache** (produção):
   - Habilite OPcache no `php.ini`
   - Aumenta significativamente a performance

4. **Monitore recursos**:
   - Verifique uso de memória
   - Analise logs de erro
   - Use ferramentas de profiling (Blackfire, Xdebug)

**Nota**: Para desenvolvimento, o servidor PHP embutido (`php -S`) é mais rápido e adequado que o XAMPP.

---

**Próximo**: [Troubleshooting Frontend](./02-frontend.md)
