# Padrões e Convenções - Frontend

## Nomenclatura

- **Components**: PascalCase (ex: `ResumoKPI.vue`)
- **Composables**: camelCase com prefixo `use` (ex: `useResumoData.ts`)
- **Services**: camelCase (ex: `resumoService.ts`)
- **Types**: PascalCase (ex: `ResumoPayload`)

## Estrutura de Componente Vue

```vue
<script setup lang="ts">
// 1. Imports
import { ref, computed } from 'vue'

// 2. Types/Interfaces
interface Props {
  // ...
}

// 3. Props
const props = defineProps<Props>()

// 4. Emits
const emit = defineEmits<{...}>()

// 5. Composables
const { data } = useSomeComposable()

// 6. Estado local
const localState = ref(null)

// 7. Computed
const computedValue = computed(() => {
  // ...
})

// 8. Métodos
const handleAction = () => {
  // ...
}

// 9. Lifecycle
onMounted(() => {
  // ...
})
</script>

<template>
  <!-- Template -->
</template>

<style scoped>
/* Estilos */
</style>
```

## TypeScript

**Sempre tipar:**

```typescript
// ❌ ERRADO
function getResumo(filters) {
  return apiGet('/api/pobj/resumo', filters)
}

// ✅ CORRETO
function getResumo(filters?: ResumoFilters): Promise<ResumoPayload | null> {
  return apiGet<ResumoPayload>('/api/pobj/resumo', filters)
}
```

## Boas Práticas

1. **Composables para lógica reutilizável**: Extrair lógica comum para composables
2. **TypeScript sempre**: Tipar tudo, evitar `any`
3. **Computed para valores derivados**: Usar `computed` em vez de métodos para valores derivados
4. **Watch com cuidado**: Usar `watch` apenas quando necessário
5. **Props imutáveis**: Nunca modificar props diretamente

---

**Voltar**: [Padrões Backend](./01-backend.md)
