# Guia de Desenvolvimento - Adicionar Novo Service

## Estrutura Base

```typescript
// src/services/novoService.ts
import { apiGet } from './api'
import { ApiRoutes } from '../constants/apiRoutes'
import type { NovoData } from '../types'

export async function getNovo(): Promise<NovoData | null> {
  const response = await apiGet<NovoData>(ApiRoutes.NOVO)
  
  if (response.success && response.data) {
    return response.data
  }
  
  return null
}
```

## Adicionar Rota em apiRoutes.ts

```typescript
// src/constants/apiRoutes.ts
export const ApiRoutes = {
  RESUMO: '/api/pobj/resumo',
  DETALHES: '/api/pobj/detalhes',
  NOVO: '/api/pobj/novo', // Nova rota
  // ...
}
```

---

**Voltar**: [Guia de Desenvolvimento](../desenvolvimento/01-novo-endpoint.md)
