# Deploy - Variáveis de Ambiente

## Backend (.env)

```bash
# API
API_KEY=sua-chave-secreta-aqui

# Database
DATABASE_URL=mysql://user:password@localhost:3306/database?serverVersion=8.0

# OpenAI (para Agent)
OPENAI_API_KEY=sk-...
OPENAI_MODEL=gpt-4

# Ambiente
APP_ENV=prod
APP_DEBUG=false
```

## Frontend (.env)

```bash
# API
VITE_API_URL=https://api.example.com
VITE_API_KEY=sua-chave-secreta-aqui

# Build
VITE_BASE_URL=/
```

## Configuração Global (Produção)

Para configuração em produção, você pode definir no HTML:

```html
<script>
  window.API_HTTP_BASE = 'https://api.example.com';
  window.API_KEY = 'sua-chave-secreta';
</script>
```

---

**Próximo**: [Build de Produção](./02-build.md)
