# Backend - Estrutura de Diretórios

## Estrutura Completa

```
backend/
├── src/
│   ├── Application/
│   │   └── UseCase/              # Lógica de negócio pura
│   │       ├── AbstractUseCase.php
│   │       ├── Pobj/             # Use cases POBJ
│   │       ├── Omega/             # Use cases Omega
│   │       └── Encantabra/        # Use cases Encantabra
│   │
│   ├── Controller/                # Endpoints HTTP
│   │   ├── ControllerBase.php     # Classe base
│   │   ├── Pobj/                  # Controllers POBJ
│   │   ├── Omega/                  # Controllers Omega
│   │   └── Encantabra/            # Controllers Encantabra
│   │
│   ├── Domain/                    # Camada de Domínio
│   │   ├── DTO/                   # Data Transfer Objects
│   │   │   ├── FilterDTO.php      # Filtros padronizados
│   │   │   ├── Resumo/            # DTOs de resumo
│   │   │   ├── Detalhes/          # DTOs de detalhes
│   │   │   └── Init/              # DTOs de inicialização
│   │   └── Enum/                  # Enumeradores
│   │       ├── Cargo.php
│   │       ├── StatusIndicador.php
│   │       └── Tables.php
│   │
│   ├── Entity/                    # Entidades Doctrine ORM
│   │   ├── Pobj/                  # Entidades POBJ
│   │   └── Omega/                 # Entidades Omega
│   │
│   ├── Repository/                # Acesso a dados
│   │   ├── Contract/              # Interfaces
│   │   ├── Pobj/                  # Repositórios POBJ
│   │   ├── Omega/                 # Repositórios Omega
│   │   ├── Encantabra/            # Repositórios Encantabra
│   │   └── Specification/         # Especificações de query
│   │
│   ├── Security/                  # Autenticação e segurança
│   │   ├── ApiKeyAuthenticator.php
│   │   ├── ApiKeyUser.php
│   │   ├── ApiKeyUserProvider.php
│   │   └── InputSanitizer.php
│   │
│   ├── EventSubscriber/           # Event subscribers
│   │   ├── CorsPreflightSubscriber.php
│   │   ├── CsrfProtectionSubscriber.php
│   │   ├── ExceptionSubscriber.php
│   │   ├── RateLimitSubscriber.php
│   │   └── RequestIdSubscriber.php
│   │
│   ├── Exception/                # Exceções customizadas
│   │   ├── AppException.php
│   │   ├── BadRequestException.php
│   │   ├── UnauthorizedException.php
│   │   ├── ForbiddenException.php
│   │   ├── NotFoundException.php
│   │   ├── ValidationException.php
│   │   └── DatabaseException.php
│   │
│   └── Infrastructure/           # Infraestrutura
│       ├── Database/              # Scripts SQL, helpers
│       ├── Helpers/               # Helpers diversos
│       └── Persistence/           # Contratos de persistência
│
├── config/                       # Configurações Symfony
│   ├── packages/                 # Configurações de bundles
│   ├── routes/                   # Configuração de rotas
│   ├── services.yaml             # DI Container
│   └── bundles.php               # Bundles registrados
│
├── migrations/                   # Migrações Doctrine
├── public/                       # Ponto de entrada
│   └── index.php
└── tests/                        # Testes
```

## Organização por Módulo

O backend está organizado em módulos:

- **Pobj/**: Funcionalidades do sistema POBJ
- **Omega/**: Sistema de chamados
- **Encantabra/**: Painel de regulamentos

Cada módulo tem seus próprios:
- Controllers
- Use Cases
- Repositories
- Entities

## Convenções de Nomenclatura

- **Controllers**: `*Controller.php` (ex: `ResumoController.php`)
- **Use Cases**: `*UseCase.php` (ex: `ResumoUseCase.php`)
- **Repositories**: `*Repository.php` (ex: `ResumoRepository.php`)
- **Entities**: PascalCase (ex: `DProduto.php`)
- **DTOs**: `*DTO.php` (ex: `FilterDTO.php`)

---

**Próximo**: [Controllers](./02-controllers.md)
