# Arquitetura do Sistema

## Diagrama de Arquitetura

```
┌─────────────────────────────────────────────────────────────┐
│                        CLIENTE (Browser)                      │
│                    Vue.js 3 SPA Application                  │
└───────────────────────┬─────────────────────────────────────┘
                        │ HTTP/HTTPS + JSON
                        │ Header: X-API-Key
                        │
┌───────────────────────▼─────────────────────────────────────┐
│                    BACKEND API (Symfony)                     │
│  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐    │
│  │  Controllers │──▶│  Use Cases   │──▶│ Repositories │    │
│  └──────────────┘  └──────────────┘  └──────┬───────┘    │
│         │                │                    │            │
│         │                │                    │            │
│  ┌──────▼──────┐  ┌──────▼──────┐     ┌──────▼───────┐   │
│  │   DTOs      │  │  Entities   │     │   Database   │   │
│  └─────────────┘  └─────────────┘     └──────────────┘   │
│                                                             │
│  ┌─────────────────────────────────────────────────────────┐ │
│  │         Event Subscribers (CORS, Rate Limit, etc)     │ │
│  └─────────────────────────────────────────────────────────┘ │
└─────────────────────────────────────────────────────────────┘
```

## Fluxo de Requisição Completo

```
1. Cliente faz requisição HTTP
   ↓
2. RequestIdSubscriber adiciona ID único
   ↓
3. CorsPreflightSubscriber trata OPTIONS
   ↓
4. RateLimitSubscriber verifica limites
   ↓
5. ApiKeyAuthenticator valida X-API-Key
   ↓
6. Controller recebe Request
   ↓
7. Controller cria FilterDTO dos query params
   ↓
8. Controller chama UseCase.handle(FilterDTO)
   ↓
9. UseCase executa lógica de negócio
   ↓
10. UseCase chama Repository métodos
    ↓
11. Repository executa queries (Doctrine/SQL)
    ↓
12. Repository retorna dados brutos
    ↓
13. UseCase transforma em DTOs
    ↓
14. UseCase retorna array estruturado
    ↓
15. Controller formata resposta JSON
    ↓
16. ExceptionSubscriber trata erros (se houver)
    ↓
17. Response JSON enviada ao cliente
```

## Camadas da Aplicação

### Backend (Symfony)

1. **Controllers**: Recebem requisições HTTP e retornam respostas JSON
2. **Use Cases**: Contêm a lógica de negócio
3. **Repositories**: Acesso aos dados (Doctrine ORM ou SQL direto)
4. **Entities**: Representam tabelas do banco de dados
5. **DTOs**: Transferem dados entre camadas
6. **Event Subscribers**: Interceptam eventos (CORS, Rate Limit, Exceptions)

### Frontend (Vue.js)

1. **Views**: Páginas/rotas da aplicação
2. **Components**: Componentes Vue reutilizáveis
3. **Services**: Cliente HTTP para comunicação com API
4. **Composables**: Lógica reutilizável com Composition API
5. **Router**: Gerenciamento de rotas
6. **Config**: Configurações (API URL, keys, etc)

## Princípios de Arquitetura

- **Separação de Responsabilidades**: Cada camada tem uma responsabilidade clara
- **Dependency Injection**: Symfony gerencia dependências automaticamente
- **Stateless**: Use Cases e Services são stateless
- **Reatividade**: Frontend usa Vue 3 Composition API para reatividade
- **Type Safety**: TypeScript no frontend, type hints no backend

---

**Próximo**: 
- [Backend - Estrutura](./backend/01-estrutura.md)
- [Frontend - Estrutura](./frontend/01-estrutura.md)
